from flask import Markup
from psynet.timeline import (
    join
)
from psynet.page import (
    InfoPage,
    TextInputPage,
    NumberInputPage,
    NAFCPage
)

from questionnaire import (
    questions,
    choices
)


instructions_experiment = InfoPage(
    Markup("""
    <h1>Instructions</h1>
    <h3>
        In this experiment you will listen to sounds and either rate them or choose from them based on a question. 
    </h3>
    <ul>
        <li>In the <strong>rating task</strong>, you will listen to a sound and rate it on a scale of four.</li>
        <li>In the <strong>choice task</strong>, you will listen to three sounds in a row and will be asked to pick the one which best matches a category in question.</li>
    </ul>
    <h3>
        Pay careful attention to the various sounds! Sometimes the differences between the sounds can be subtle, choose what seems most accurate to you.
    </h3>
    <p>
        <strong>Remember:</strong> The consistency of your responses will be checked automatically,
        and high quality responses will be bonused accordingly at the end of the experiment. 
        The best strategy is just to honestly report what you think sounds better!
        Also, sometimes the sounds might take a moment to load, so please be patient.
    </p>
    """),
    time_estimate=3
)

final_questionnaire= join(
    InfoPage(
        Markup("""
        <h3>Thank you for completing the task!</h3>
        <br>
        Before we finish,
        please answer a few final questions.
        """),
        time_estimate=3
    ),
    NumberInputPage(
        "age",
        "Please indicate your age in years.",
        time_estimate=3,
        one_line= True
    ),
    NAFCPage(
        label= "gender",
        prompt= "What is your gender?",
        choices= ["Female", "Male", "Other", "Prefer not to specify"],
        time_estimate=3,
        arrange_vertically=False
    ),
    TextInputPage(
        "country",
        Markup("""
            What country are you from?
            """),
        time_estimate=3,
        one_line=True
    ),
    TextInputPage(
        "mother_tongue",
        Markup("""
            What is your mother tongue?
            """),
        time_estimate=3,
        one_line=True
    ),
    NAFCPage(
        label= "musical_experience",
        prompt= questions["musical_experience"],
        choices= choices["musical_experience"],
        time_estimate=3,
        arrange_vertically=False
    ),
    NumberInputPage(
        label= "years_playing_music",
        prompt= questions["years_playing_music"],
        time_estimate=3,
        one_line= True
    ),
    TextInputPage(
        "which_instrument",
        Markup(
            questions["which_instrument"]
            ),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "favourite_bands",
        Markup(
            questions["favourite_bands"]
            ),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "last_song_heard",
        Markup(
            questions["last_song_heard"]
            ),
        time_estimate=5,
        one_line=False
    ),
    NAFCPage(
        label= "hearing_issues",
        prompt= questions["hearing_issues"],
        choices= choices["hearing_issues"],
        time_estimate=3,
        arrange_vertically=False
    ),
    NAFCPage(
        label= "education",
        prompt= questions["education"],
        choices= choices["education"],
        time_estimate=3,
        arrange_vertically=False
    ),
    TextInputPage(
        "feedback",
        Markup("""
            Did you like the experiment?
            """),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "technical_problems",
        Markup("""
            Did you encounter any technical problems during the
            experiment? <br>If so, please provide a few words describing the
            problem.
            """),
        time_estimate=5,
        one_line=False
    )
)

